<?php

function ref_options_page(){

	global $ref_options;

	$pluginDocumentation = 'https://www.race-space.com';

	ob_start(); ?>

	<div class="wrap" id="ref-admin">

		<h2><?php _e('Race Space Embed Form Setup', 'ref_domain'); ?></h2>
		<form method="post" action="options.php" id="ref-admin-main">

			<?php settings_fields('ref_settings_group'); ?>
			<div>
				<h3><?php _e('Custom CSS', 'ref_domain'); ?></h3>
				<p>
					<textarea style="width:350px;height:125px;" class="regular-text" type="text" id="ref_settings[mailCustomCSS]" name="ref_settings[mailCustomCSS]" ><?php echo $ref_options['mailCustomCSS']; ?></textarea>
				</p>
				<p id="ref-submit">
					<input type="submit" value="<?php _e('Save Options', 'ref_domain'); ?>" class="btn">
				</p>
			</div>

			<div class="clearfix"></div>
		</form>

		<div id="ref-admin-side">
			<h3><?php _e('Geared by:', 'ref_domain'); ?></h3>
			<div id="ref-authorbox">
				<a href="https://www.race-space.com" title="Race Space" id="logo">
					<img src="<?php echo plugin_dir_url( __FILE__ ) . 'img/racespace-logo-dark.svg'; ?>">
				</a>
				<div id="details">
					<p><strong>Version:</strong>&nbsp;1.0.1</p>
					<p><strong>Author:</strong>&nbsp;Race Space Team</p>
					<p><strong>Web:</strong>&nbsp;<a href="https://www.race-space.com">Home</a></p>
				</div>
				<div class="ref-admin-clearfix"></div>
			</div>
			<h3><?php _e('Basic Documentation', 'ref_domain'); ?></h3>
			<p>Shortcode attributes for Race Space's embed button</p>
			<table class="table" cellpadding="0" cellspacing="0">
				<tr>
					<td><strong>Attribute</strong></td>
					<td><strong>Description</strong></td>
					<td><strong>Code Usage</strong></td>
				</tr>
				<tr>
					<td>rsembed</td>
					<td>Main shortcode attribute</td>
					<td>[rsembed]</td>
				</tr>
				<tr>
					<td>event</td>
					<td>The Race Space event url that you want to embed on the page. | Default: empty (Will flag an error)</td>
					<td>[rsembed event="https://www.race-space.com/gb/organiser-name/event-name"]</td>
				</tr>
				<tr>
					<td>class</td>
					<td>For additional class attribute for the button. | Default: empty</td>
					<td>[rsembed class="additional_class"]</td>
				</tr>
				<tr>
					<td>text</td>
					<td>Custom text that you want for the button. | Default: "Enter Now"</td>
					<td>[rsembed text="Register Now!"]</td>
				</tr>
				<tr>
					<td>wrap</td>
					<td>Put a custom wrapper for the child button. This will serve as the buttons parent element. It can be any of these selections <strong>[div, p, section, article, a]</strong>. If you put <strong>"disable"</strong> it will remove the wrapper and just retain the embed button element. | Default: "p" (with class attribute of "ref-btn-wrap")</td>
					<td>[rsembed wrap="p"] or [rsembed wrap="disable"]</td>
				</tr>
			</table>
		</div>
		<div class="ref-admin-clearfix"></div>
	</div>
	<?php
	echo ob_get_clean();
}

function ref_add_options_link(){
	add_options_page('Race Space Embed Form', 'Race Space Embed Form', 'manage_options', 'ref-options', 'ref_options_page');
}

add_action('admin_menu', 'ref_add_options_link');

function ref_register_settings(){

	register_setting('ref_settings_group', 'ref_settings');

}

add_action('admin_init', 'ref_register_settings');
