<?php

/*****************************

* Scripts Includes

*****************************/

function ref_load_scripts(){
	
	wp_enqueue_style('ref-styles', plugin_dir_url( __FILE__ ) . 'styles/ref_styles.css');

	wp_enqueue_script(
		'ref-scripts',
		plugin_dir_url( __FILE__ ) . 'js/ref_scripts.js',
		array( 'jquery' )
	);
	
}

add_action('wp_enqueue_scripts', 'ref_load_scripts');

function ref_admin_styles() {
    wp_register_style( 'ref_admin_stylesheet', plugins_url( 'styles/ref_admin_styles.css', __FILE__ ) );
    wp_enqueue_style( 'ref_admin_stylesheet' );
    wp_register_script( 'ref_admin_scripts', plugins_url( 'js/ref_admin_scripts.js', __FILE__ ) );
    wp_enqueue_script( 'ref_admin_scripts' );

}

add_action( 'admin_enqueue_scripts', 'ref_admin_styles' );

function ref_custom_css()
{
	global $ref_options;

	$output="<style type='text/css'> ".$ref_options['mailCustomCSS']." </style>";

	echo $output;

}

add_action('wp_footer','ref_custom_css');