<?php
/*
Plugin Name: Race Space Embed Form
Plugin URI: https://www.race-space.com
Description: Provides options for Race Space organisers to embed their event forms by just adding a simple [rsembed] shortcode on their page.
Version: 1.0.1
Author: Race Space Team
Author URI: https://race-space.com

Race Space Embed Form is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
any later version.

Race Space Embed Form is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Media Modal. If not, see {License URI}.

*/

/*****************************
* Global Variables
*****************************/

$ref_plugin_name = 'ref';
$ref_options = get_option('ref_settings');

/*****************************
* Includes
*****************************/

include('lib/ref-scripts.php');//All Scripts Here

include('lib/ref-admin-page.php');//All Admin Page

function ref_settings_link($links) {
  $settings_link = '<a href="options-general.php?page=ref-options.php">Settings</a>';
  array_unshift($links, $settings_link);
  return $links;
}

$plugin = plugin_basename(__FILE__);
add_filter("plugin_action_links_$plugin", 'ref_settings_link' );

include('lib/ref-ajax.php');//All JS

include('lib/ref-functions.php');//All Display and Shortcodes
